	cpu Z8601
	page 0
	include stddefZ8.inc

;********************************************************************
; 
;              Apple 10MB ProFile - Z8 diag firmware
;                         Version D1.06
;            original code (c) by Apple Computer Inc., 1981
;
;           disassembly and comments by Patrick Schfer, 2013
;                      last changes 2014-01-23 PS
;
;********************************************************************


ROMsize		SET 4096
DontListIncls	SET 1				; set to skip listing for .inc

VersionHi	SET 006h
VersionLo	SET 006h



	include DefsProFile10LLF.inc

	org 00000h
 		DB 001h, 050h, 008h, 097h 
	
; step motor: 2 bipolar phases connected to P0.4..P0.7
; it takes two steps from one track to the next one
StepVal		DB 050h,040h,060h,020h		; sw, w, nw, n directions
		DB 0A0h,080h,090h,010h		; ne, e, se, s directions
;
Start		jp ColdStart
;
; Step motor speed profiles
AccelTab	DB 006h, 08bh, 016h, 012h	; prescaler values
		DB 00eh, 00ah, 00eh, 00ah
		DB 00eh, 00ah, 04eh, 04eh
		DB 016h, 00eh, 00ah, 016h
		DB 012h, 012h, 01ah, 00bh
		DB 086h, 00bh, 086h, 001h
		DB 00eh, 08fh, 066h, 066h
 		DB 01ah, 00bh, 086h, 001h

 		DB 090h, 060h, 060h, 0a0h	; delay after two steps
		DB 090h, 0c0h, 070h, 080h
		DB 090h, 080h, 070h, 050h
		DB 060h, 060h, 0c0h, 060h
		DB 0c0h, 0d0h, 0b0h, 060h
		DB 050h, 080h, 050h, 000h
		DB 050h, 050h, 070h, 070h
		DB 0c0h, 0b0h

		DB 0c0h, 012h, 01fh, 038h	; delay between two steps 
		DB 014h, 02ch, 019h, 00ch
		DB 01dh, 02ch, 01dh, 00ch
		DB 00ch, 038h, 01eh, 019h
		DB 038h, 013h, 00dh, 025h
		DB 01fh, 015h, 01dh, 015h
		DB 000h, 00ch, 019h, 01dh
		DB 01dh, 045h, 01ah, 007h

;
;********************************************************************
;  This is the Reset entry point
;********************************************************************
;
ColdStart	clr IMR				; disable all interrupts
		ei     
		di     
		ld 0D8h,#016h			; should be 0F8h -- P01M !!
		ld SPL,#Stack_Top		; stack starts at 080h  
		clr SPH
		srp #WorkingRegs		; select register bank 4
	assume RP:WorkingRegs
 		ld P2M,#007h			; P2.7..P2.3 output, P2.2..P2.0 input
		ld R0,#0FFh
		ld P2,R0			; set all bits of P2 high
		ld R1,#9
ClrLoop1	ld ActCylH-1(R1),R0		; set 010..018h to 0FFh
		djnz R1,ClrLoop1
		ld R2,#11
ClrLoop2	ld Status1-1(R2),R1		; set 007..011h to 000h
		djnz R2,ClrLoop2
		clr 02Eh
		clr 02Fh
		clr FirstTrackFlg
		clr 030h
		clr Head
		ld RAM_MSB,#RAM/256
		clr HeaderBufLSB
 		ld P3M,#001h			; port 2 push-pull, P3H output, P3L input
		ld P3,#WRTSM			; set WRTSM, clear HS0, HS1, RDHDR
		clr P0				; turn off stepper
		ld 034h,#0FFh
		call InitCTC			; initialize i8253 counter
		inc PwrFlg0			; check for cold start
		jr nz,SpinUpDly			; PwrFlg0 <> 0FFh -> power on!
		dec PwrFlg1			; PwrFlg1 <> 001h -> power on!
		jr nz,SpinUpDly
		ld Status2,#Power_Reset
		jp WarmStart
; wait 18 s for the spindle motor
SpinUpDly	ld R0,#105
SpinUpLoop	call WaitR12ms
		djnz R0,SpinUpLoop
;
;********************************************************************
; and here we go...
;********************************************************************
;
WarmStart	ld CylinderH,#308/256
		ld CylinderL,#308#256
		ld 03Dh,#0FFh
		call Seek1			; park heads
		clr 03Dh
		and P2,#0FFh-BSY		; set BSY
WarmStart1	ld PwrFlg0,#0FFh		; set warm start flags
		ld PwrFlg1,#001h
		ld SPL,#Stack_Top		; dump stack
WarmStart2	ld R14,#1			; 01 means waiting for command
		call DoHandshake		; wait for host to assert /CMD
;
; *** we end up here after successful 01 - 55 handshake ***
; get command bytes from host
GetHostCmd	ld R0,#HostCmdBuffer/256
		ld R1,#HostCmdBuffer#256
		call SetRAMforHost		; set RAM adress to HostCmdBuffer
		and P2,#0FFh-DRW_Read-Msel0-Msel1-BSY	; Apple --> Mem & set BSY
 		call WaitCmdLine		; wait for host to dma in command bytes and assert /CMD
 		call RAMtoZ8			; set Mem --> Z8
		ld R15,#HostCmdLength		; copy host command from RAM (R0.R1) to registers (R15)
CopyHostCmd	ld R14,#7			; copy seven bytes
CopyHostCmdLp	ldei @R15,@RR0		
		djnz R14,CopyHostCmdLp
		cp HostCmdLength,#000h		; classic read command?		
		jr nz,DoHostCmd1		;  no -->
		cp HostCommand,#0FFh		; spare table block?
		clr HostCommand			; set diag read command
		jp z,DoHostCmd2			;  and continue
		jp WarmStart2			; abort for all other blocks
DoHostCmd1	ld ActSector,Sector
		cp HostCommand,#00Eh		; invalid command (>0Eh)?
		jp ugt,WarmStart2		;  yes --> abort
; verify checksum
		ld R0,HostCmdLength
		ld R1,HostCmdLength
		ld R2,#HostCommand		; first byte for checksum calculation
		dec R0				; don't add checksum byte
DoHostCmd3	add R1,@R2
		inc R2
		djnz R0,DoHostCmd3
		com R1
		cp R1,@R2
		jp nz,WarmStart2		; abort on mismatch
; process host command
DoHostCmd2	ld R14,HostCommand
		inc R14
		inc R14				; generate response byte
		call SetResponse		; and send it to host
		ld RAM_MSB,#RAM/256
		ld HeaderBufLSB,#RAM#256
		and Status1,#Stat_NoIdx+Stat_Seek_Err	; clear everything but seek error
		ld R2,#CommandTable/256
		ld R3,#CommandTable#256
		rl HostCommand
		add R3,HostCommand		; point to command vector
		ldc R10,@RR2			; get MSB of command address
		inc R3
		ldc R11,@RR2			; get LSB
		ld R0,FirstTrackFlg		; old FirstTrackFlg value in R0
		ld R1,Status4			; old Status4 value in R1
		clr FirstTrackFlg
		clr Status4
		clr FormatFlag
		jp @RR10			; and go there
;
; these are ProFile's debug commands
; 
; ProFile 10M diag commands have the following format:
; HostCmdLength / HostCommand / ... / Checksum
; Checksum is the inverted sum of all command bytes except for the checksum itself.
; However, the classic 00 FF FF FF command to read the ID block is still supported.
CommandTable	DW HostCmdRead		; 00 READ
		DW HostCmdWrite		; 01 WRITE
		DW HostCmdScan		; 02 SCAN ALL BLOCKS
		DW HostCmdSeek		; 03 SEEK
		DW HostCmdFormat	; 04 FORMAT
		DW HostCmdInit		; 05 INIT SPARE TABLE
		DW HostCmdRAMtst	; 06 TEST CONTROLLER RAM
		DW HostCmdReadHdr	; 07 READ HEADER
		DW HostCmdErase		; 08 ERASE TRACK
		DW HostCmdWrSM		; 09 WRITE SECTOR MARKS
		DW HostCmdWrHdr		; 0A WRITE HEADERS
		DW HostCmdStepMot	; 0B TURN OFF STEPPER
		DW HostCmdPark		; 0C PARK HEADS
		DW HostCmdResTab	; 0D GET RESULT TABLE
; 
;********************************************************************
; *** Host Command 03: Seek to cylinder/head
;
; Parameter:	cylinderH/cylinderL/head/sector
; Returns:	Status
;
; If sector =1, no headers are checked on the destination track.
; Otherwise, a regular seek is done.
; A seek to track 0, head 0 also clears the format error counter 
; (Status4).
;********************************************************************
;
HostCmdSeek	ld FirstTrackFlg,R0		; restore old values
		ld Status4,R1
		tm Sector,#001h			; even sector number?
		jr nz,HostCmdSk1		;  no -->
		ld MaskChkHdr,#0FFh		;  else skip header verification
HostCmdSk1	ld R0,CylinderH 
		or R0,CylinderL
		or R0,Head			; cylinder & head =0?
		jr nz,HostCmdSk2		;  no -->
		clr FirstTrackFlg		;  else clear fault counter
		clr Status4
HostCmdSk2	call Seek
		jp AbortState			; exit with operation failed status
; 
;********************************************************************
; *** Host Command 04: Format current track
;
; Parameter:	none
; Returns:	Status4: number of faulty blocks
;		RAM: list of bad blocks 
;
; If FirstTrackFlg =0, a new result table is started
;********************************************************************
;
HostCmdFormat	ld FirstTrackFlg,R0		; restore old values
		ld Status4,R1
		cp FirstTrackFlg,#0		; do we start here
		jr nz,HostCmdFmt1		;  no -->
		ld R0,#AuxBuffer/256		;  else clear result table
		ld R1,#AuxBuffer#256
		call FmtRTab_WrEnd
HostCmdFmt1	call Get1stSctr			; get sector number to start with (interleaving!)
		call Fmt_SectorMarks		; write sector marks and headers
		call Fmt_DataFields		; initialize data fields
		ld R0,#(AuxBuffer-4)/256
		ld R1,#(AuxBuffer-4)#256
		jp SendState1			; and return result table
; 
;********************************************************************
; *** Host Command 0D: Get result table
;
; Parameter:	none
; Returns:	Status
; 		RAM: result table
;********************************************************************
;
HostCmdResTab	ld R0,#(AuxBuffer-4)/256
		ld R1,#(AuxBuffer-4)#256
		jp SendState1			; return result table
;
; get first sector for given head (ActSector = 3x Head)
Get1stSctr	ld ActSector,#-3
		ld R0,Head
		inc R0
Get1stSctr1	add ActSector,#3
		djnz R0,Get1stSctr1
		ret    
; 
;********************************************************************
; *** Host Command 08: Erase track
;
; Parameter:	cylinderH/cylinderL/head
; Returns:	Status
;********************************************************************
;
HostCmdErase	dec FormatFlag			; FormatFlag = 0FFh (erase only)
		call Seek1
		jr c,HostCmdErs1		; abort on seek error
		call Fmt_SectorMarks		; open write gate
		call WaitIdxPulse		; wait for another two rotations
		call WaitIdxPulse
HostCmdErs1	jp SendState			; the RAM access closes the write gate
; 
;********************************************************************
; *** Host Command 09: Write sector marks
;
; Parameter:	cylinderH/cylinderL/head/0/count
;		count = number of sector marks to be written (16)
; Returns:	Status
;********************************************************************
;
HostCmdWrSM	inc FormatFlag			; FormatFlag = 001h (R3 holds number of marks)
		call Seek1
		jr c,HostCmdWrSM1		; abort on seek error
		ld R3,RetryCnt
		call Fmt_SectorMarks
HostCmdWrSM1	jp SendState
; 
;********************************************************************
; *** Host Command 0A: Write headers
;
; Parameter:	cylinderH/cylinderL/head/0/count
;		count = number of headers to be written (16)
; Returns:	Status
;********************************************************************
;
HostCmdWrHdr	dec FormatFlag			; FormatFlag = 0FFh (R3 holds number of headers)
		call Seek1
		jr c,HostCmdWrHdr1		; abort on seek error
		call Get1stSctr			; get sector number to start with (interleaving!)
		call Fmt_Headers
HostCmdWrHdr1	jp SendState
; 
;********************************************************************
; *** Host Command 00: Read
;
; Parameter:	cylinderH/cylinderL/head/sector
; Returns:	Status
;		RAM: user data
;********************************************************************
;
HostCmdRead	cp CylinderH,#0FFh		; spare table?
		jr nz,HostCmdRd1		;  no -->
		call Copy_ID_Block		; get spare table template
		ld R1,#(WriteBuffer+ST_FwRev)#256	
		ld R2,#0D0h+VersionHi		; insert FW revision MSB
		lde @RR0,R2	
		ld R1,#(WriteBuffer-4)#256
		jp SendState1
; regular data blocks	
HostCmdRd1	ld ActSector,Sector
		cp ActSector,#16		; sector out of range?
		jr c,HostCmdRd2			;  no -->
		or Status2,#Illegal_Track	;  else abort
		jp SendState
;
HostCmdRd2	call Seek
		call DoRead			; do actual read operation
		or Status1,RWstat
; send status with operation failed bit set
AbortState	jr nc,SendState	
		or Status1,#Op_Failed 
;
; copy status bytes into ReadBuffer
;
SendState	ld R0,#(ReadBuffer-4)/256
		ld R1,#(ReadBuffer-4)#256
		ld P3,P3Mask2
		or P2,#MSel0+MSel1		; Z8 --> Mem
		ld P01M,#016h			; connect bus
		or P2,#DRW_Read+DSTART		; stop state machine
		and P0,#0FFh-PreComp
SendState1	ld R2,#Status1
		ld R3,#4			; lenght 4 bytes
SendSt_Lp	ldei @RR0,@R2			; copy status bytes into buffer
		djnz R3,SendSt_Lp
		sub R1,#4			; set RAM pointer back to buffer start
;
; give control to host with DMA pointer at RR0
;
SendState2	call SetRAMforHost
		and P2,#0FFh-BSY		; set BSY
; *** now the host may pick up his status bytes ***
		clr Status2
		clr Status3
		jp WarmStart1
;
;
; *** copy ID block (spare table constants) into WriteBuffer
;
Copy_ID_Block	ld R0,#WriteBuffer/256
		ld R1,#WriteBuffer#256
		ld R2,#ID_Block/256
		ld R3,#ID_Block#256
		ld R4,#26			; 26 bytes
Copy_ID_Loop	ldc R5,@RR2
		lde @RR0,R5
		incw RR0
		incw RR2
		djnz R4,Copy_ID_Loop
		ret    
;
;
; *** enter current block number into FmtResultTab
;
FmtRTab_Enter	swap ActHead
		or ActHead,ActSector		; merge head with sector
		ld R2,#ActCylH
		ldei @RR0,@R2			; ActCylH
		ldei @RR0,@R2			; ActCylL
		ldei @RR0,@R2			; ActHead + ActSector 
		and ActHead,#0F0h		; remove head nibble
		swap ActHead
		ld R2,#Status1
		ldei @RR0,@R2			; Status1
; write end mark (FF FF FF FF) into RAM buffer
FmtRTab_WrEnd	ld R2,#0FFh			; end marker
		ld R3,#4			; write four bytes
FmtRTab_WE1	lde @RR0,R2
		incw RR0
		djnz R3,FmtRTab_WE1
		ret    
;
;
; *** setup data fields, i.e. fill 16 sectors with a D6B9 pattern
; fill buffer with 24 bytes if FirstTrackFlg set, with 532 bytes if 02D cleared
;
Fmt_DataFields	ld R5,#2
		ld R0,#WriteBuffer/256
		ld R1,#WriteBuffer#256
		ld R2,#0D6h			; fill pattern
		ld R3,#0B9h
		ld R4,#2			; fill 2x 2 bytes
		rl FirstTrackFlg				; FirstTrackFlg set?
		jr nz,FmtDF_Loop		;  yes -->
		clr R4				;  else fill 2x 256 bytes
		dec FirstTrackFlg			;   and clear FirstTrackFlg
FmtDF_Loop	ld R6,#WorkingRegs+2		; (this is R2)
		ldei @RR0,@R6			; copy R2 contents into WriteBuffer
		ldei @RR0,@R6			; copy R3 contents into WriteBuffer
		djnz R4,FmtDF_Loop
		ld R4,#10			; fill 2x 10 bytes
		djnz R5,FmtDF_Loop
; write 16 blocks
		ld R14,#16			; fill 16 sectors
FmtDF2		and Status1,#0FFh-Stat_No_Hdr	; clear header error
		add ActSector,#7
		and ActSector,#15
		call DoWrite			; and write data to disk
		or Status1,RWstat		; was there an error?
		jr nc,FmtDF1			;  no --> next one
		cp Status4,#070h		; more than 112 faults?
		jr nc,FmtDF3			;  no -->
; enter fault in result table
		ld R0,#0
		ld R1,Status4
		rl R1
		rlc R0
		rl R1
		rlc R0				; RR0 = Status *4
		and R1,#0FCh			; clear bit 1+0
		add R1,#AuxBuffer#256		; and add result table start address
		adc R0,#AuxBuffer/256
		call FmtRTab_Enter
FmtDF3		inc Status4			; increment number of faults
		jr nz,FmtDF1			; more than 255 faults?
		dec Status4			;  yes --> stop at 255
FmtDF1		djnz R14,FmtDF2			; all done?
Ret_5		ret    
;
;
; *** fill the current track with zeroes and write 16 sector marks onto it
;
Fmt_SectorMarks	ld R0,#FMTEN/256
		ld R1,#FMTEN#256
		ld P3,P3Mask2
		and P2,#0FFh-DRW_Read-Msel0	; Mem --> State Machine (Disk)
		lde @RR0,R2			; dummy write to open write gate (if jumper closed)
; now the disk spins while a continuous 0 is applied -- this erases the track
		ld P01M,#01Ch			; tristate bus lines (P1)
		and P0,#0FFh-PreComp
		ld R4,ActCylH
		ld R5,ActCylL
		sub R5,#128
		sbc R4,#0
		jr mi,FmtSM1
		or P0,#PreComp			; enable precompensation above track 128
FmtSM1		ld R1,#211			; (delay between index and first sector)
		rl FormatFlag			; check FormatFlag
		jp mi,Ret_5			; exit if called from CMD 8 or A (0FFh)
		jp nz,FmtSM2			; skip if called from CMD 9 (001h, then R3 = RetryCnt)
		ld R3,#16			; 16 sector marks to be written
		call WaitIdxPulse		; wait for index
FmtSM2		call WaitIdxPulse
; now write R3 sector marks
FmtSM2a		djnz R1,$			; wait some more		
		ld R1,#209
		ld R2,#3			; (20s duration of sector mark)
		and P3,#0FFh-WRTSM		; begin sector mark...
FmtSM3		djnz R2,FmtSM3			;  ...wait...
		or P3,#WRTSM			;  ... done.
		djnz R3,FmtSM2a			; next one
; done, exit
		ld P01M,#016h			; reconnect bus
		or P2,#DRW_Read+Msel1+Msel0	; Z8 --> Mem
		rl FormatFlag			; continue with headers if called from HostCmdFormat
		jp nz,Ret_5
;
;
; *** write a header after each sector mark
;
Fmt_Headers	ld R0,#RAM/256
		ld R1,#RAM#256
		ld R3,#0
		ld R9,#22			; zero first 22 bytes in buffer
FmtHdr1		lde @RR0,R3
		incw RR0
		djnz R9,FmtHdr1
		ld R3,#1
		lde @RR0,R3			; 1017h = 001h
		incw RR0
		call BuildWrtHdr		; build header template for first sector
		and P2,#0FFh-Msel1		; Z8 --> Timer 
		ld R1,#3			; i8253 control register
		ld R2,#030h			; counter 0 mode 0 (16 bit count)
		ld R3,#070h			; counter 1 mode 0 (16 bit count)
		ld P01M,#036h			; select slow memory timing 
		lde @RR0,R2
		lde @RR0,R3
		ld R1,#0
		ld P3,P3Mask1
		ld R10,#16			; 16 headers to be written
		rl FormatFlag			; called from HostCmdFormat?
		jr z,FmtHdr3			;  --> yes
		ld R10,RetryCnt			;  else use RetryCnt for number of headers
FmtHdr3		ld R9,#60
FmtHdr2		djnz R9,FmtHdr2			; wait some more time
  		and P2,#0FFh-DRW_Read-DSTART 	; start state machine
		or P2,#Msel1+Msel0
		and P2,#0FFh-MSel0		; Mem --> State Machine (Disk)
		lde @RR0,R2			
		ld P01M,#01Ch			; tristate bus lines
		and P0,#0FFh-PreComp
		ld R4,ActCylH
		ld R5,ActCylL
		sub R5,#128
		sbc R4,#0
		jr mi,FmtHdr4
		or P0,#PreComp			; enable precompensation above track 128
FmtHdr4		call WaitSctrPulse		; wait for sector mark
		jr nz,FmtHdr5			; continue if not timeout
		or Status1,#Stat_NoSect
		inc Status3
FmtHdr5		ld R9,#50
		djnz R9,$	   		; wait some time
		or P2,#Msel1+Msel0		; Z8 --> Mem
		and P0,#0F0h
		ld P01M,#016h			; back to fast memory timing
		or P2,#DRW_Read+DSTART 		; stop state machine
		ld R1,#(RAM+27)#256
		ld R0,RAM_MSB
		add ActSector,#7		; first 0, A, 4, E, 8, 2, C, 6
		cp R10,#9			; 8 sectors left to write
		jr z,FmtHdr6			;  yes -->
		add ActSector,#3		; then  D, 7, 1, B, 5, F, 9, 3
FmtHdr6		and ActSector,#15
		ld R7,ActSector
		ld R8,ActSector
		com R8
		lde @RR0,R7			; sector in 101Bh
		add R1,#4
		lde @RR0,R8			; complemented sector in 101Fh
		ld R1,#0
		cp R10,#9			; R10 resp. RetryCnt = 9?
		jr nz,FmtHdr7			;  no -->
		ld R9,#217
		djnz R9,$	   		; wait some time
FmtHdr7		ld R9,#224
		djnz R10,FmtHdr2
; all done. Now restore the CTC registers and exit
		ld P3,P3Mask2
;
; initialize i8253 counter (one shot mode: a L->H transition at gate starts the pulse)
InitCTC		ld R1,#003h			; control register at 0FF03h
		ld R3,#032h			; counter 0 mode 1 (one shot 16 bit)
		ld R4,#072h			; counter 1 mode 1 (one shot 16 bit)
		ld R5,#092h			; counter 2 mode 1 (one shot 8 bit)
		ld P01M,#036h			; set slow memory timing
		and P2,#0FFh-Msel1  		; select Z8 --> Timer 
		lde @RR0,R3
		lde @RR0,R4
		lde @RR0,R5
		jp RAMtoZ8a
;
; ***** do handshake with host *****
; profile waits for CMD to go active, then puts (R14) onto data bus
; after CMD went inactive again, 55h is expected as ACK
;	
DoHandshake	call WaitCmdLine		; wait for CMD
SetResponse	or P2,#Msel0+Msel1    		; Z8 --> Mem
		ld P01M,#006h	 		; set P1 as output
		ld P1,R14			; and send response to host
		or P2,#BSY	   		; clear BSY
DoHsk_Wait	tm P2,#CMD
		jp nz,DoHsk_Wait		; wait until CMD line goes low
		ld P01M,#00Eh			; set P1 as input
		and P2,#0FFh-Msel0-Msel1  	; Apple --> Mem
		and P2,#0FFh-Msel0-Msel1-DRW_Read
		ld R0,P1			; get answer from host
		call RAMtoZ8			; Mem --> Z8
		cp R0,#055h			; ACK?
		jp z,Ret_2			; ok, finished
		or Status1,#Bad_55		; record NAK in status byte
		jp SendState
;
; ***** wait for host /CMD *****
; this routine waits until CMD (P2.2) is pulled high by the host
;
WaitCmdLine	ld P01M,#01Ch			; tristate bus lines
WaitCmdLineLp	tm P2,#CMD			; did host pull CMD high?
		jp z,WaitCmdLineLp
Ret_2		ret  
;
; wait for a index pulse. timeout (Z=0) if none has arrived within 26 ms.
;
WaitIdxPulse	clr IRQ
		call SetT0_26ms
WaitIP_Loop	tm T0,#0FFh
		jr nz,WaitIdxPulse1
		or Status1,#Stat_NoIdx+Op_Failed 
		jp SendState
;
WaitIdxPulse1	tm IRQ,#1			; did a index pulse (P3.2=hi) occur?
		jp z,WaitIP_Loop
		and Status1,#0FFh-Stat_NoIdx
		ret    
;
; wait for a sector pulse. timeout (Z=0) if none has arrived within 26 ms.
;
WaitSctrPulse	ld T0,#172
		ld PRE0,#16
		ld TMR,#00000011b		; load & start T0
		clr IRQ				;  and clear P3.1 interrupt flag
WaitSP_Loop	tm T0,#0FFh			; did timer run off?
		jp z,WaitSP_Done
		tm IRQ,#4			; did a sector pulse (P3.1=hi) occur?
		jp z,WaitSP_Loop
WaitSP_Done	ret    				; return if timer run off or sector pulse arrived
;
; wait for the state machine to finish. DiskSM_Timeout = 0FFh if timeout, Z=0 if ok.
;
WaitDiskSM	clr RWstat
		clr DiskSM_Timeout
		call SetT0_26ms			; timeout = 6* 26ms = 156ms
WaitDSM2	tm T0,#0FFh			; timer expired?
		jr nz,WaitDSM1			;  no --> check state machine
		or RWstat,#Stat_No_Hdr		; report timeout error 
		dec DiskSM_Timeout
		ret    
;
WaitDSM1	ld R4,#2
WaitDSM3	tm P2,#SECTDN			; state machine finished?
		jp nz,WaitDSM2			;  no --> continue waiting
		djnz R4,WaitDSM3		;  yes, check again to be sure
		ret    
;
; setup T0 for a single 26.1 ms delay
;
SetT0_26ms	ld T0,#0FFh
		clr PRE0
		ld TMR,#00000011b		; load & start T0
		ret  
; 
; 
; *** build a header for current CHS and put it into (R0.HeaderBufLSB)
;
BuildHeader	ld R1,HeaderBufLSB 		; LSB of header address
BuildHdr1	ld R10,#1
		ld R3,#4			; complement 4 bytes
BldHdr_Lp1	ld R4,ActCylH-1(R3)		; copy 010..013h (HostCommand, head, sector)
		com R4
		ld ComCylH-1(R3),R4		;  complemented into 014..017h
		djnz R3,BldHdr_Lp1
		ld R2,#9			; copy 9 bytes
		ld R15,#HeaderImage
BldHdr_Lp2	ldei @RR0,@R15			; copy 010..017 into RAM (R0.01Dh)
		djnz R2,BldHdr_Lp2
		ld R9,#7
BldHdr_Lp3	lde @RR0,R2			; clear the following 7 bytes
		inc R1
		djnz R9,BldHdr_Lp3
		ret   
; 
; set RAM address to (R0.HeaderBufLSB) and prepare RAM for disk access
;
SetRAMforDisk	ld R1,HeaderBufLSB 
		and P2,#0FFh-DSTART-Msel0	; State Machine --> Mem, start state machine
SetRAM		lde @RR0,R2			; dummy write to set RAM address to R0.R1
		ld P01M,#01Ch			; release data & address bus
		ret    
; 
; set RAM address to RR0 and prepare RAM for host access
;
SetRAMforHost	and P2,#0FFh-Msel0-Msel1	; Apple --> Mem
		jp SetRAM
;
; prepare i8253 CTC
;
LoadCTCforRd	ld R2,#551#256
		ld R3,#553#256
		ld R4,#17
LoadCTC		and P2,#0FFh-Msel1		; Z8 --> Timer
		ld R0,RAM_MSB
		ld R1,#0			; counter 0 data register
		ld R5,#551/256			; MSB is the same for all ctrs
		ld P01M,#036h			; select slow memory timing
		lde @RR0,R2			; set counter 0 = 551 (16 bit, LSB first)
		lde @RR0,R5
		inc R1
		lde @RR0,R3			; set counter 1 = 553 (16 bit, LSB first)
		lde @RR0,R5
		inc R1
		lde @RR0,R4			; set counter 2 = 17 (8 bit)
		ld P3,P3Mask2			; WRTSM + Heads
		jp RAMtoZ8a
;
;
; *** do actual read operation ***
; returns carry set when error occurred
;
DoRead		ld StatusBufLSB,#(ReadBuffer-4)#256
		ld RAM_MSB,#RAM/256
		clr HeaderBufLSB 		; read header will be built at 01000h
DoRead1		call WaitSctrPulse		; wait for sector mark
DoScan		call LoadCTCforRd		; start timers
		call BuildHeader		; build header image in RAM
ReadHeader	call SetRAMforDisk		; start state machine
		call WaitDiskSM			; and wait for its job to be done
		jr nz,ReadHdr1			; timeout --> 
		tm P3,#CRCERR			;  no, CRC fault?
		jr nz,ReadHdr1			;   no -->
		dec DiskSM_Timeout		;   else set fault flag,
		or RWstat,#Stat_Rd_Err		;   and set CRC error flag
ReadHdr1	and P3,#0FFh-RDHDR
DoWrite3	or P2,#DSTART			; stop state machine
; give RAM back to our microcontroller
RAMtoZ8		or P2,#DRW_Read
RAMtoZ8a	or P2,#Msel0+Msel1		; Z8 --> Mem
		and P0,#0F0h
		ld P01M,#016h			; reconnect bus
		rl DiskSM_Timeout		; and set carry if fault occurred
		ret    
; 
; *** write block to disk
; returns carry set when error occurred
;
DoWrite		ld StatusBufLSB,#(WriteBuffer-4)#256
		tm Status1,#Stat_Seek_Err	; did the seek fail?
		jp nz,DoWrite_Abort		;  yes --> abort
		rl SettlingReqd			; did we just move the heads?
		jr nc,DoWrite1			;  no --> continue
		clr SettlingReqd
		ld R12,#40			; else wait some time to settle
		call WaitR12ms
DoWrite1	call WaitSctrPulse		; wait for sector mark
		ld RAM_MSB,#RAM/256
		clr HeaderBufLSB 		; build write header at 01000h
		ld R2,#570#256
		ld R3,#574#256
		ld R4,#38
		call LoadCTC			; prepare i8253 for write sequence
		clr R1
		call BuildWrtHdr		; build header image in RAM
		call SetRAMforDisk		; start state machine
		and P2,#0FFh-DRW_Read
		and P0,#0FFh-PreComp
		ld R4,ActCylH
		ld R5,ActCylL
		sub R5,#128
		sbc R4,#0
		jr mi,DoWrite2
		or P0,#PreComp			; enable precomp for cylinders >128
DoWrite2	call WaitDiskSM			; wait for state machine to be finished
		jp DoWrite3			; and leave via ReadHeader
;
DoWrite_Abort	ld DiskSM_Timeout,#0FFh		; set fault flag
		jp RAMtoZ8a			; and leave
;
BuildWrtHdr	call BuildHdr1			; build regular header image
		ld R9,#22
		call BldHdr_Lp3			; zero another 22 bytes
		lde @RR0,R10			; followed by a 001h
		inc R1
		lde @RR0,R2			; followed by another 000h
		ret    
;
;
; *** Seek Routine ***
;
Seek1		ld MaskChkHdr,#0FFh		; don't check headers
; enter here for R/W seek
Seek		rl 02Eh				; 02Eh set?
		jr nz,_05a8			;  yes -->
;
		push CylinderH			; save cylinder
		push CylinderL
		ld OldMaskCkHdr,MaskChkHdr	; save check headers flag
		ld ActCylH,#333/256
		ld ActCylL,#333#256
		ld CylinderH,#332/256		; some illegal values
		ld CylinderL,#332#256
		or Status2,#020h
_0578		ld MaskChkHdr,#0FFh		; and do not check headers here
		call _05a8
		decw ActCylH
		incw ActCylH
		jr z,_059e
		cp CurStep,#0
		jr nz,_0591
		sub CylinderL,#4
		sbc CylinderH,#0
		jr _0593
_0591		decw CylinderH 
_0593		jp pl,_0578
		rl 03Dh				; initial seek to parking position?
		jp nz,Ret_4			;  yes --> exit here
		jp SendState
;
_059e		ld 02Eh,#0FFh			; set 02Eh
		pop CylinderL			; restore cylinder
		pop CylinderH
		ld MaskChkHdr,OldMaskCkHdr	; restore check headers flag
_05a8		clr 031h	
		clr OnTrackFlg
		rl 034h				; 034h set?
		jr z,Seek_Loop			;  no -->
		ld R10,#2
		call MoveStepMot1
		clr 031h
		ld R12,#37
		call WaitR12ms
		clr 034h
Seek_Loop	rl 02Eh				; 02Eh set?
		jp z,_05d8			;  no -->
		cp CylinderH,#310/256		; valid cylinder?
		jp lt,_05d8
		jr nz,Seek_BadTrk		;  no --> abort!
		cp CylinderL,#310#256
		jp lt,_05d8
Seek_BadTrk	or Status2,#Illegal_Track
		scf    
		jp SendState
;
_05d8		cp Head,#4			; valid head?
		jp ge,Seek_BadTrk		;  no --> abort!
		call _06eb
		jp z,Seek_OnTrack
		tm P2,#Trk0			; are we on Track 0?
		jr nz,_0604			;  no -->
		cp 035h,#0FFh			; 035h set?
		jr nz,_0604			;  yes -->
		cp CurStep,#0			; are we at Phase 0?
		jr nz,_0604			;  no -->
		clr ActCylH			;  else syncronize ActCyl to the HDA
		clr ActCylL
		rl 02Eh				; 02Eh set?	
		jr nz,_0601			;  yes -->
		ld MaskChkHdr,OldMaskCkHdr	;  else restore check header flag
		and Status2,#0FFh-020h
_0601		jp Seek_OnTrack

_0604		call _073e
		call _073e
		jr nz,_061a
		ld ActCylH,CylinderH 
		ld ActCylL,CylinderL
_0612		ld R12,036h
		call WaitR12ms			; wait
		jp Seek_OnTrack
;
_061a		cp CurStep,#0			; are we at Phase 0?
		jr nz,_0622			;  no -->
		tm P2,#Trk0			; are we on Track 0?
_0622		jp nz,_0604			;  no -->
		rr R8
		jp nc,_0604
		cp 035h,#0FFh			; 035h set?
		jp nz,_0604			;  yes -->
		clr ActCylH			; syncronize ActCyl to the HDA
		clr ActCylL
		rl 02Eh				; 02Eh set?
		jr nz,_063e			;  yes -->
		ld MaskChkHdr,OldMaskCkHdr	;  else restore check header flag
		and Status2,#0FFh-020h
_063e		jp _0612
; now we arrived at our destination track
Seek_OnTrack	ld R0,Head
		swap R0
		or R0,#WRTSM
		ld P3Mask2,R0			; generate P3 masks: 005 = 01hh0000
		ld P3,R0			; select head
		or R0,#WRTSM+RDHDR
		ld P3Mask1,R0			; 004 = 11hh0000
		ld R12,#1
		ld R0,ActHead			; remember old head number in R0
		ld ActHead,Head			;  and update ActHead
		rl MaskChkHdr			; skip header checks?
		clr MaskChkHdr		
		inc OnTrackFlg			; have the heads been moved?
		jr nc,Seek_OnTrk1		;  no header checks -->
		rcf    
		ld R12,#2			; (short settling time)
		jr nz,_066a			;  no head movement -->
		ld R12,#70			;  else use long settling time
		and Status1,#0FFh-Stat_Seek_Err	;  and clear seek error
_066a		jp WaitR12ms
Seek_OnTrk1	jr z,Seek_OnTrk2		; go on to the header checks
		cp R0,Head			; has the head changed?
		rcf    
		jp nz,WaitR12ms			;  yes --> wait and leave from there
		ret   				;  else leave now    
; now let's read three consecutive headers within four disk revolutions
Seek_OnTrk2	ld OnTrackCtr,#4*16		; four disk revolutions = 64 sectors
		ld RAM_MSB,#SeekHeaderBuf/256
		ld HeaderBufLSB,#SeekHeaderBuf#256
		call WaitSctrPulse
Seek_BadHdr	ld R13,#3			; three headers to be checked
Seek_OnTrk3	dec OnTrackCtr			; bump trial counter
		jr nz,Seek_ChkHdr		;  and check next one
		or Status1,#Stat_Seek_Err	; set seek error if counter expired
		scf    
		ret    
; 
Seek_ChkHdr	ld T1,#15
		call Wait1ms_1
		call LoadCTCforRd
		ld P3,P3Mask1			; WRTSM + RDHDR + Heads
		call ReadHeader			; read next header
		jp nz,Seek_BadHdr		; abort on fault
		inc R1
		inc R1				; RR0 = 13E2h
		ld R15,#WorkingRegs+3
		ld R14,#8
Seek_ChkHdr4	ldei @R15,@RR0			; copy header into R3..R10
		djnz R14,Seek_ChkHdr4
		cp R3,#2
		jp nc,Seek_BadHdr		; cylinder out of range
		cp R6,#16
		jp nc,Seek_BadHdr		; sector out of range
		adc R7,R3
		jp nz,Seek_BadHdr		; cylinderH & complement mismatch
		adc R8,R4
		jp nz,Seek_BadHdr		; cylinderL & complement mismatch
		adc R9,R5
		jp nz,Seek_BadHdr		; head & complement mismatch
		adc R10,R6
		jp nz,Seek_BadHdr		; sector & complement mismatch
		ld ActCylH,R3
		ld ActCylL,R4
		cp CylinderH,ActCylH		; wrong cylinder?
		jr nz,Seek_ChkHdr1
		cp CylinderL,ActCylL
Seek_ChkHdr1	jp nz,Seek_ChkHdr2
		cp ActHead,R5			; wrong head?
		jr z,Seek_ChkHdr3
Seek_ChkHdr2	or Status2,#Stat_Seek		; set seek to wrong track flag
		jp Seek_Loop			;  and try again
Seek_ChkHdr3	djnz R13,Seek_OnTrk3		; decrement todo list
; done -- we successfully read three headers within four disk revolutions
		and Status1,#0FFh-Stat_Seek_Err	; clear seek error
		rcf    
Ret_4		ret    
;
; calculate seek offset
; returns Z=0 if on target track, 036h = delay, 030.31h = difference
_06eb		clr R6
		clr 037h
		clr 038h
		ld 035h,#1
		ld R4,CylinderH 
		ld R5,CylinderL
		sub R5,ActCylL			; RR4 = target - current
		sbc R4,ActCylH
		ld R7,FLAGS
		jr pl,_070b			; go forward? -->
		ld 035h,#-1
		com R4				; make difference positive
		com R5
		incw RR4
_070b		decw RR4
		incw RR4			; set zero flag if difference =0
		push FLAGS			;  and save it
		sub R5,#9			; difference >9?
		sbc R4,R6
		jr pl,_0725			; yes -->
; come here if less then 9 tracks to go
		dec 037h			; set 037h
		ld 036h,#26			; delay = 26
		add 038h,#24			; 038h = 24
		add R5,#8			; now RR4 = difference -1
		jr _0735
; come here if more than 9 tracks to go 
_0725		ld 036h,#28			; delay = 28
		sub R5,#10			; subtract another 10 
		sbc R4,R6
		jr pl,_0732			; still positive -->
		ld 036h,#35			; else delay = 35
_0732		add R5,#11			; now RR4 = difference -8
;
_0735		adc R4,R6			; adjust MSB
		ld 032h,R4
		ld 033h,R5
		pop FLAGS			; restore zero flag
		ret    
;
; called after _06eb did not return zero
_073e		ld R6,#AccelTab/256
		ld R7,#AccelTab#256
		add R7,038h			; 038h is initial 0 or 24
		ldc R8,@RR6			; get prescaler from first table into R8
		ld R10,R8
		and R10,#03Eh			; mask out bit 7+6+0
		or R10,#002h			; set bit 1
		add R7,#32			; next table starts 32 bytes later
		ldc R9,@RR6			; get timercnt from second table into R9
		add R7,#30			; third table starts 30(!) bytes later
		ldc R11,@RR6			; get interstep delay from 3rd table into R11
		tm R8,#080h			; has prescaler bit7 set? 
		jr z,_076c			;  no -->
		com 035h			
		inc 035h			; swap sign
		add CurStep,035h		; and add to current phase
		add CurStep,035h		;  (i.e. move phase one step back)
		com 035h			; restore sign 
		inc 035h
_076c		tm R8,#040h			; has value1 bit6 set? 
		jr z,MoveStepMot		;  no -->
		tm 038h,#001h			; table offset odd?
		jr nz,_0781			;  yes -->
		decw 032h
		jp pl,MoveStepMot
		add 038h,#2
		jp _073e
;
; ***** move step motor ****
;
_0781		sub 038h,#2
MoveStepMot	add CurStep,035h
		and CurStep,#7
MoveStepMot1	ld OnTrackFlg,#0FFh
		ld SettlingReqd,#0FFh
		ld R2,#StepVal/256
		ld R3,#StepVal#256
		add R3,CurStep
		ldc R6,@RR2			; get step value from table
		rl 031h
		ld 031h,#0FFh
		jr z,_07b4
MoveSMdly1	tm T1,#0FFh
		jp nz,MoveSMdly1
		ld PRE1,#6
		ld T1,R11			; interstep delay from table 3
		ld TMR,#12
MoveSMdly2	tm T1,#0FFh
		jp nz,MoveSMdly2
_07b4		ld PRE1,R10			; prescaler from table 1
		ld T1,R9			; after step delay from table 2
		ld P0,R6
		ld TMR,#12
		inc 038h
		dec R8
		ret    
;
; ***** pause for 0.64 ms *****
;
Wait1ms		ld T1,#100
Wait1ms_1	ld PRE1,#012h			; use internal clock/4 (156.25kHz)
		ld TMR,#00Ch			; load & start timer
Wait1msLoop	tm T1,#0FFh
		jp nz,Wait1msLoop
		ret   
;
; ***** pause for 21.76 ms *****
;
Wait_22ms	ld R12,#34			; 34*0.64 ms = 21.76 ms
; pause for R12 * .064 ms
WaitR12ms	call Wait1ms			; wait for 0.64 ms
		djnz R12,WaitR12ms
		ret    
; 
;********************************************************************
; *** Host Command 05: Init spare table
;
; Parameter:	none
; Returns:	Status4: number of faulty blocks
;		RAM: list of bad blocks 
;********************************************************************
;
HostCmdInit	ld CylinderL,#153
		clr CylinderH
		ld Head,#2
Init_NextHd	call Seek			; go to spare track
		tm Status1,#Stat_Seek_Err	; seek error?
		jr nc,HostCmdIn1		;  no -->
		or Status1,#Op_Failed 		;  else abort
		jp SendState
HostCmdIn1	ld ActSector,#15
		ld TempRegs+0,#0FFh		; write end of table marker
Init_NextSctr	call Copy_ID_Block		; copy spare table template into RAM
		ld R2,#0FFh
		ld R3,#100			; followed by 200 bytes 0FFh
Init_Loop1	lde @RR0,R2
		incw RR0
		lde @RR0,R2
		incw RR0
		djnz R3,Init_Loop1
		ld R0,#(WriteBuffer+ST_SpareMapEnd)/256
		ld R1,#(WriteBuffer+ST_SpareMapEnd)#256
		ld R2,#SpareSublists/256
		lde @RR0,R2			; 10DC = 012h (byte B4h)
		inc R1
		ld R2,#SpareSublists#256
		lde @RR0,R2			; 10DE = 0DCh (byte B5h)
		call WriteBlockCHS		; write block onto disk
		jr nc,HostCmdIn2		;  ok? -->
; here we found a faulty block
		or Status3,ActSector		; merge sector number into Status3
		ld R0,Head
		swap R0		
		and R0,#010h
		or Status3,R0			; merge in head (2->0, 3->1)
		ld R0,#TempRegs			; store results in register 050h ff
		add R0,Status4			; calculate pointer
		ld @R0,Status3			; and store result byte
		inc Status4			; bump error counter
HostCmdIn2	dec ActSector			; next sector
		jp pl,Init_NextSctr		; all 15 done?
		inc Head			; next head
		and Head,#3
		jp nz,Init_NextHd		; both done?
; two tracks finished, exit
		ld R0,Status4
		add R0,#TempRegs
		ld R1,#0FFh			; write end mark
		ld @R0,R1
		ld R0,#ReadBuffer/256
		ld R1,#ReadBuffer#256
		ld R2,#050h
		ld R3,#32
Init_Loop2	ldei @RR0,@R2			; copy results into ReadBuffer
		djnz R3,Init_Loop2
		jp SendState
; 
;********************************************************************
; *** Host Command 01: Write
;
; Parameter:	cylinderH/cylinderL/head/sector
;		RAM: user data
; Returns:	Status
;********************************************************************
;
HostCmdWrite	ld ActSector,Sector
		cp Sector,#16
		jr c,HostCmdWr1
		or Status2,#Illegal_Track
		jp SendState
HostCmdWr1	call Seek
		ld R0,#WriteBuffer/256
		ld R1,#WriteBuffer#256
		call SetRAMforHost
		and P2,#0FFh-DRW_Read-BSY	; clear P2.7, set BSY
		ld R14,#6			; 06 means write confirmation
		call DoHandshake		; wait for host to assert /CMD
; 
; *** now the host DMAs his data into the write buffer... ***
; we end up here after successful 01 - 55 handshake
		clr Status3
		call DoWrite
		or Status1,RWstat
		jp AbortState
; 
;********************************************************************
; *** Host Command 0B: Turn off stepper
;
; Parameters:	none
; Returns:	nothing
;********************************************************************
;
HostCmdStepMot	clr P0				; turn off stepper
		and Status1,#0FFh-Stat_Seek_Err
		ld 034h,#0FFh
HostCmdPk1	jp SendState
; 
;********************************************************************
; *** Host Command 0C: Park heads
;
; Parameters:	none
; Returns:	nothing
;********************************************************************
;
HostCmdPark	ld CylinderH,#308/256
		ld CylinderL,#308#256
		call Seek1
		jp HostCmdPk1
; 
;********************************************************************
; *** Host Command 04: Scan
;
; Parameters:	none
; Returns:	Status4: number of potential bad blocks
;		RAM: list of bad blocks followed by FF FF FF FF
;********************************************************************
;
HostCmdScan	clr 58
		ld R0,#ReadBuffer/256
		ld R1,#ReadBuffer#256
		clr CylinderH
		clr CylinderL
		clr Head
		call FmtRTab_WrEnd		; start with empty table
Scn_Next	and Status1,#0FFh-Stat_Seek_Err	; clear everything but seek error
		call Seek
		ld RAM_MSB,#SeekHeaderBuf/256
		ld HeaderBufLSB,#SeekHeaderBuf#256
		add R6,#10
		tm Status1,#Stat_Seek_Err	; seek error?
		jr z,HostCmdScn1		;  no -->
		or 58,#16
_08bd		call WaitSctrPulse
		sub R6,#3
HostCmdScn1	ld T1,#15
		call Wait1ms_1
		ld ActSector,R6
		and ActSector,#15
		ld R13,#2			; first do 0, A, 4, E, 8, 2, C, 6
HostCmdLp2	ld R14,#8			;     then 3, D, 7, 1, B, 5, F, 9
		clr 59
		ld 44,#1
HostCmdLp1	and Status1,#Stat_Seek_Err	; clear everything but seek error
		call DoScan
		or Status1,RWstat		; error occurred?
		jr nc,HostCmdScn2
		or 59,44
		cp Status4,#243
		jr nc,_0902
		clr R0
		ld R1,Status4
		rl R1
		rlc R0
		rl R1
		rlc R0
		and R1,#0FFh-3
		add R1,#ReadBuffer#256
		adc R0,#ReadBuffer/256
		call FmtRTab_Enter
_0902		inc Status4
		jr nz,HostCmdScn2
		dec Status4
HostCmdScn2	add ActSector,#10
		and ActSector,#15
		ld T1,#15
		call Wait1ms_1
		rl 44
		djnz R14,HostCmdLp1
		ld R9,#3
		ld R10,#10
_091c		rl 59
		jr c,_0927
		dec R9
		jp z,_092e
		jr _0929
_0927		ld R9,#3
_0929		djnz R10,_091c
		or 58,#2
_092e		sub ActSector,#3		; do second group
		and ActSector,#15
		djnz R13,HostCmdLp2
; 16 sectors done
		inc Head			; next head
		and Head,#3
		jr z,_0948
		call Seek
		ld R6,ActSector
		sub R6,#9
		jp _08bd
; next cylinder
_0948		incw CylinderH 
		cp CylinderH,#305/256
		jp nz,Scn_Next
		cp CylinderL,#305#256
		jp nz,Scn_Next
		or Status1,58
		jp HostCmdPark
; 
;********************************************************************
; *** Host Command 06: Test RAM
;
; Parameter:	none
; Returns:	Status1 = 1 if failed
; 		RAM: failed address MSB, LSB, check pattern,
;		     pattern read back
;********************************************************************
;
HostCmdRAMtst	clr Status1
		clr Status2
		clr Status3
		ld R0,#RAM/256
		ld R1,#RAM#256
		ld R2,#055h
		call RAMfill		; fill RAM with 055h
		ld R0,#RAM/256
		ld R1,#RAM#256
		call RAMcomp		; compare RAM
		jp c,HostCmdRtstFail	; mismatch?
		ld R0,#RAM/256
		ld R5,#0AAh
		call RAMtest
		ld R0,#RAM/256
		ld R1,#RAM#256
		ld R2,#0AAh
		call RAMfill		; fill RAM with 0AAh
		ld R0,#RAM/256
		ld R1,#RAM#256
		call RAMcomp		; compare RAM
		jp c,HostCmdRtstFail	; mismatch?
		ld R0,#RAM/256
		ld R5,#055h
		call RAMtest
		jp SendState
;
HostCmdRtstFail	or Status1,#Op_Failed  
		ld R6,#ReadBuffer/256
		ld R7,#ReadBuffer#256
		ld R8,#WorkingRegs+0
		ld R9,#4
HostCmdRtstF1	ldei @RR6,@R8		; copy R0..R3 into ReadBuffer
		djnz R9,HostCmdRtstF1
		jp SendState
;
; fill RAM from (RR0) to 13FFh with R2
RAMfill		lde @RR0,R2		; store pattern
		inc R1			; next byte
		jr nz,RAMfill1		; page done?
		inc R0			; next page
		cp R0,#01400h/256	; all done?
		jp z,RAMfill2		;  yes -->
RAMfill1	jp RAMfill
RAMfill2	ret    
;
; compare RAM from (RR0) to 13FFh with pattern in R2. Returns C=1 when error
RAMcomp		lde R3,@RR0		; get byte
		cp R2,R3		; compare
		jr z,RAMcomp1		; match -->
		scf    			; else set carry flag
		ret    
RAMcomp1	inc R1			; next byte
		jr nz,RAMcomp2
		inc R0			; next page
		cp R0,#01400h/256	; all done?
		jp z,RAMcomp3		;  yes -->
RAMcomp2	jp RAMcomp
RAMcomp3	rcf    			; C=0 when passed
		ret    
;
; test RAM from (RR0) to 13FFh with pattern in R5
RAMtest		ld R2,R5
		com R2			; R2 = inverted test pattern
_09d6		lde @RR0,R5		; store pattern
		ld R6,#16
		jp _09e4
_09dd		lde R3,@RR0		; read back
		cp R2,R3		; match?
		jp nz,HostCmdRtstFail	;  no --> abort 
_09e4		ld R7,R1
		and R7,#7
		cp R7,#7
		jr z,_09f1
		inc R1
		jr _09f7
_09f1		and R1,#0F8h
		xor R0,#002h
_09f7		djnz R6,_09dd
		ld R6,#040h
		jp _0a05
_09fe		lde R3,@RR0		; read back
		cp R2,R3		; match?
		jp nz,HostCmdRtstFail	;  no --> abort 
_0a05		add R1,#8
		jr nc,_0a0d
		xor R0,#001h
_0a0d		djnz R6,_09fe
		lde @RR0,R2
		inc R1
		jr nz,_0a15
		inc R0
_0a15		cp R0,#01400h/256	; all done?
		jp nz,_09d6
		ret    
; 
;********************************************************************
; *** Host Command 07: Read header
;
; Parameter:	cylinderH/cylinderL/head/sector/retry count
; Returns:	Status
;		RAM: header + user data
; 
; reads <sector>'th sector on the track if RetryCnt <>0
; reads sector number <sector> if RetryCnt =0
;********************************************************************
;
HostCmdReadHdr	call Seek
		ld R4,Sector
		inc R4
		ld R13,R4			; R13 = sector +1
		cp RetryCnt,#0			; RetryCnt =0?
		jr nz,HostCmdRH1		;  no -->
		ld R13,#-4
HostCmdRH2	add R13,#5			; apply interleaving
		djnz R4,HostCmdRH2
		add R13,Head
		and R13,#15
HostCmdRH1	cp R13,#0			; sector count =0?
		jr nz,HostCmdRH3		;  no -->
		add R13,#16			;  else make it 16
HostCmdRH3	ld RAM_MSB,#RdHdrBuffer/256
		ld HeaderBufLSB,#RdHdrBuffer#256
		call WaitIdxPulse		; wait for index
HostCmdRH4	call WaitSctrPulse
		djnz R13,HostCmdRH4		; skip unwanted sectors
		call LoadCTCforRd
		ld P3,P3Mask1
		call ReadHeader			; do actual read operation
		or Status1,RWstat		; read failed?
		jr nc,HostCmdRH5		;  no -->
		or Status1,#Op_Failed 
HostCmdRH5	and P3,#0FFh-RDHDR
		ld R0,#(RdHdrBuffer-4)/256
		ld R1,#(RdHdrBuffer-4)#256
		jp SendState1
;
; ***** spare table template *****
;
ID_Block	DB "PROFILE 10M", 0, 0
		DB 000h, 000h, 010h
		DB 0D1h, VersionLo
		DB 000h, 04Ch, 000h
		DW 00214h
		DB 020h, 000h, 000h
;
;********************************************************************
; store WriteBuffer into current Cylinder/Head/Sector
; read back and compare if HostCommand = 2
; exit with Carry set if failed
;********************************************************************
;
WriteBlockCHS	clr Status3
		call DoWrite			; perform actual write operation
		or Status1,RWstat		; merge result into Status1
		jp c,Ret_2			; write fault --> exit
		cp HostCommand,#2		; simple write?
		jp z,Ret_2			; yes --> exit
; verify the block we just have written
		ld R12,#10
		call WaitR12ms			; wait 10ms
		ld RAM_MSB,#AuxBuffer/256	; build header for readback at 1240h
		ld HeaderBufLSB,#AuxBuffer#256	;  and store data at 1254h ff.
		or Status3,#ReadTimeout		; set read timeout bit	
		call DoRead1			; read back our data
		or Status1,RWstat		; merge result into Status1
		call RdErrCRC			; and set CRC bit if read error
		jp c,Ret_2			; read fault --> exit
; now compare the data we read back with the bytes we got from the host
		ld R0,#WriteBuffer/256		; original data from host
		ld R1,#WriteBuffer#256
		ld R2,#(AuxBuffer+20)/256	; data just read back from disk
		ld R3,#(AuxBuffer+20)#256
		ld R4,#428/256			; sorry, we can compare only the first 
		ld R5,#428#256			;  428 bytes -- there is not enought RAM !
		or Status3,#DataCompare		; set data mismatch bit
WB_CHS_CmpLp1	lde R6,@RR0
		lde R7,@RR2
		incw RR0
		incw RR2
		cp R6,R7			; now compare each byte
		jp nz,WB_CHS_VfyErr		; exit on mismatch
		decw RR4
		jp nz,WB_CHS_CmpLp1
		and Status3,#0FFh-ReadCRC-DataCompare	; clear error flags
; copy the last 104 bytes host data to end of RAM
		ld R0,#(WriteBuffer+428)/256	; original data from host
		ld R1,#(WriteBuffer+428)#256
		ld R2,#(01400h-532+428)/256	
		ld R3,#(01400h-532+428)#256
		ld R4,#104
WB_CHS_CmpLp2	lde R5,@RR0
		lde @RR2,R5
		incw RR0
		incw RR2
		djnz R4,WB_CHS_CmpLp2
; read the block a second time
		call DoRead			; read back our data
		or Status1,RWstat		; merge result into Status1
		call RdErrCRC			; and set CRC bit if read error
		jp c,Ret_3			; read fault --> exit
; and compare the remaining bytes
		ld R0,#(ReadBuffer+428)/256
		ld R1,#(ReadBuffer+428)#256
		ld R2,#(01400h-532+428)/256	; moved host data
		ld R3,#(01400h-532+428)#256
		ld R4,#532-428			; now do the remaining 104 bytes
		or Status3,#DataCompare		; set data mismatch bit
WB_CHS_Cmp2	lde R6,@RR0
		lde R7,@RR2
		incw RR0
		incw RR2
		cp R6,R7			; now compare each byte
		jr z,WB_CHS_Cmp1		; ok --> next one
; verify failed, exit with C=1
WB_CHS_VfyErr	or Status1,#Op_Failed 
		scf    
		ret    
; next byte to cpmpare
WB_CHS_Cmp1	djnz R4,WB_CHS_Cmp2
		clr Status3			; clear error flags
		rcf    
Ret_3		ret    
;
;
; copy read error (CRC) bit from RWstat into Status3
;
RdErrCRC	tm RWstat,#Stat_Rd_Err		; read error occurred?
		jr z,RdErrCRC1			;  no -->
		or Status3,#ReadCRC		;  else set CRC bit in Status3
RdErrCRC1	ret  


	end